<?php

namespace Import\ApiBundle\Services\Import;


class ImportAvgPayment extends ImportMainService
{
    protected $url = 'http://www.wskazniki.gofin.pl/9,83,658,2,przecietne-wynagrodzenie-miesieczne-w-sektorze.html';

    protected $columns = array("Okres","Value");

    protected $errors = array();

    public function import()
    {
        $this->type = 'ImportAvgPayment';

        $title = 'Przeciętne wynagrodzenie miesięczne w sektorze przedsiębiorstw';
        $links = $this->getLinksFromPage($this->url,$title);
        $links = array_reverse($links);

        $count = 0;
        $i = 0;
        $countRow = count($links);
        echo '('.count($links).') ';
        foreach($links as $id => $link)
        {
//            $this->printPercent($i,$countRow);
            echo ($count > 0 && $count % 10 == 0) ? '|' : '.';
            $PaymentAvg = $this->getDoctrine()->getRepository('ImportApiBundle:PaymentAvg')->getAvgPaymentForMonthAndYear($link['month'],$link['year']);
            if(empty($PaymentAvg))
            {
                $link['value'] = $this->getPaymentAvgFromPage($link['href']);
                $this->save($link);
                $count++;
            }
            $i++;
        }
        $this->getDoctrine()->getEntityManager()->flush();
        $this->viewErrors();

        return array('count' => $count);
    }

    protected function validRow($row)
    {
        $valid = true;

        foreach($this->columns as $column)
        {
            if((!isset($column)) || ($row[$column] == ' ') || (empty($row[$column])))
            {
                $valid = false;
                $this->addError(1,$column,$this->type);
            }
        }

        return $valid;
    }

    protected function addDataToRow($row)
    {
        $data = $row[$this->columns[0]];
        $data = str_replace('od','',$data);
        $data = str_replace('r.','',$data);
        $data = str_replace('za','',$data);
        $data = str_replace('dzień','',$data);
        $data = trim($data);

        $dataArray = explode(' ',$data);

        if(count($dataArray) != 3)
        {
            return false;
        }

        $DataTime = $this->createDataFromArray($dataArray);

        if(!$DataTime)
        {
            $this->addError(2,$row[$this->columns[0]],$this->type);
            return false;
        }
        $row['DataFrom'] = $DataTime;

        $row[$this->columns[1]] = trim($row[$this->columns[1]]);
        $row[$this->columns[1]] = str_replace(',','.',$row[$this->columns[1]]);

        return $row;
    }

    protected function save($data)
    {
        $this->getDoctrine()->getRepository('ImportApiBundle:PaymentAvg')->add($data);

        return true;
    }
}